.\" $Id: sccsget.man,v 6.6 2025/09/28 19:29:22 tom Exp $
.TH SCCSGET 1 2025-09-28 "" "User commands"
.ie n .ds CW R
.el   \{
.ie \n(.g .ds CW CR
.el       .ds CW CW
.\}
.de Es
.ne \\$1
.nr mE \\n(.f
.RS 5n
.sp .7
.nf
.nh
.ta 9n 17n 25n 33n 41n 49n
.ft \*(CW
..
.de Eh
.ft \\n(mE
.fi
.hy \\n(HY
.RE
.sp .7
..
.\" Bulleted paragraph
.de bP
.ie n  .IP \(bu 4
.el    .IP \(bu 2
..
.SH NAME
\fBsccsget\fR \-
SCCS check-out script
.SH SYNOPSIS
\fBsccsget\fI [options] [file-specifications]\fR
.SH DESCRIPTION
\fBSccsget\fR is a simple interface to \fIsccs\fR
(\fBs\fRource \fBc\fRode \fBc\fRontrol \fBs\fRystem),
which is used to extract files from \fIsccs\fR archives.
.PP
\fBSccsget\fR checks out (extracts) files from an \fIsccs\fR
archive which have been checked in using \fBsccsput\fR.
\fBSccsput\fR
checks in files, retaining their modification date as the check-in
date.
\fBSccsget\fR extracts a given version of one or more files,
and sets their modification date to match the check-in date.
.SH OPTIONS
\fBSccsget\fR is a directory-recursive interface
to the \fBgetdelta\fR utility (which invokes \fIsccs\fR's \fBget\fR)
which does special things with the file modification date.
Most of its options are passed to \fBget\fR, and then interpreted to determine
the correct modification date:
.TP
.BI \-c cutoff
specifies the \fIsccs\fR cutoff date, in the format
.Es
YY[MM[DD[HH[MM[SS]]]]]
.Eh
.RS
.PP
Punctuation in the date is permitted.
For example,
.Es
-c 77/2/2 9:22:25
-c 770202092225
.Eh
.PP
represent the same date.
.RE
.TP
.B \-f
forces \fBsccsget\fR to remove the current version
of the file before extracting the specified version.
Otherwise, \fBsccsget\fR will refuse to overwrite a file which already exists.
.TP
.B \-k
directs get to extract the specified file without
substituting sccs identification keywords.
You should use this option
if you intend to make updates to the file.
.TP
.B \-n
suppresses the \fBget\fR-operation.
Instead, \fBsccsget\fR echoes an "ok" message
for files which would be extracted.
.TP
.BI -r SID
specifies the \fIsccs\fR identification
string (SID) of the version of an \fIsccs\fR file to be retrieved.
.TP
.B \-s
suppresses most messages written by the \fBget\fR
utility (i.e., those written to standard output).
.SH OPERATIONS
To extract files using \fBsccsget\fR, you must provide one or more
names.
They may be either file or directory names.
.PP
\fBSccsget\fR resolves names until it finds one of the form "sccs/s.
\fIfile\fR" before invoking \fBget\fR.
If it finds a directory
(other than "SCCS"), \fBsccsget\fR will recur on itself to
extract files at lower levels.
.SH ENVIRONMENT
\fBSccsget\fR is a Bourne shell script.
On Apollo DOMAIN/IX, it
uses System\ 5 features, including \fIgetopt\ (1)\fR.
Environment
variables used by \fBsccsget\fR include:
.TP
.B SCCS_DIR
specifies the directory in which \fBgetdelta\fR will find the "s." files.
If not specified, \fBgetdelta\fR
assumes "SCCS".
.SH FILES
Sccsget uses the following files:
.TP
.B sccsget
the Bourne shell script
.TP
.B getdelta
a utility which invokes \fBget\fR,
and then modifies the file's modification date after check-out so
that the file's modification date matches the version-date selected
with the "-\fBc\fR" or "-\fBr\fR" option.
.SH ANTICIPATED CHANGES
None.
.SH AUTHORS
Thomas Dickey (Software Productivity Consortium).
.SH SEE ALSO
getdelta, sccsput, ded, get(1)
