.\" $Id: checkin.man,v 11.9 2025/09/28 23:02:39 tom Exp $
.TH CHECKIN 1 2025-09-28 "" "User commands"
.ie n .ds CW R
.el   \{
.ie \n(.g .ds CW CR
.el       .ds CW CW
.\}
.de Es
.ne \\$1
.nr mE \\n(.f
.RS 5n
.sp .7
.nf
.nh
.ta 9n 17n 25n 33n 41n 49n
.ft \*(CW
..
.de Eh
.ft \\n(mE
.fi
.hy \\n(HY
.RE
.sp .7
..
.\" Bulleted paragraph
.de bP
.ie n  .IP \(bu 4
.el    .IP \(bu 2
..
.SH NAME
\fBcheckin\fR \-
RCS check-in utility
.SH SYNOPSIS
\fBcheckin\fI [options] [file-specifications]\fR
.SH DESCRIPTION
\fBCheckin\fR is an extension of the RCS utility \fBci\fR.
It uses the file's modification date rather than the current date
as the RCS delta-date.
.PP
\fBCheckin\fR uses the \fIrcs\fR utility \fBci\fR.
It is normally invoked from the \fBrcsput\fR script, but may be invoked
in a standalone manner.
\fBCheckin\fR differs from \fBci\fR
primarily in its treatment of the delta date: after invoking \fBci\fR,
\fBcheckin\fR modifies the delta-date in the archive to reflect
the file's modification date.
.PP
This is the fundamental advantage offered by \fBcheckin\fR.
The ordinary \fIrcs\fR methodology uses the current date as the check-in date.
This works well only for large projects in which a central
project administrator is responsible for controlling the versions
of source files.
It does not work well for small projects,
for which \fIrcs\fR's primary advantage is
its compact storage of multiple versions of a file.
.PP
By using the file's modification date as a reference, you can more
easily back up to a meaningful version \- by date, rather than
version number.
.SS "Archive Directory"
If the archive directory (e.g., "./RCS") does not exist, \fBcheckin\fR
creates it before invoking the \fBci\fR program.
.SS "Set-UID Operation"
The rcs \fBci\fR and \fBco\fR utilities work to a degree in
set-uid mode (i.e., the "u+s" protection is set on the programs).
However, the code assumes that the effective uid is \fBroot\fR,
and does not concern itself with maintaining file ownership.
.PP
The \fBcheckin\fR package is able to run as a set-uid process
for any particular user (e.g., the administrator of a project).
For example, suppose that \fB/proj\fR is the location of project-specific
tools, and is owned by \fBadmin\fR.
Then (running as the \fBadmin\fR user):
.Es 2
cp checkin /proj		# admin now owns this copy
chmod 4755 /proj/checkin	# sets u+s mode
.Eh
.PP
Thereafter, users who invoke \fB/proj/checkin\fR will have
the rights of \fBadmin\fR \- for this application.
They may
check into \fIrcs\fR any files which they own, into archives
which \fBadmin\fR owns.
\fBCheckin\fR will maintain \fBadmin\fR's ownership
of the archive files, and the user's ownership of his working files.
.PP
If \fBcheckin\fR does not need the set-uid rights (e.g.,
if the user already owns the archive), \fBcheckin\fR resets its
effective uid to the user's.
This permits a single copy of \fBcheckin\fR
to be used for both configuration management as well as individual
developers.
.SS "Sharing RCS Archives"
\fBCheckin\fR provides support for shared files by using \fIrcs\fR's
access lists, and providing special handling for set-uid operation:
.bP
When you first archive a file using \fBcheckin\fR,
it invokes the \fBrcs\fR administrative utility to initialize
the access list of the file.
It puts the \fIeffective\fR user
into the list.
.bP
If \fBcheckin\fR is running in set-uid mode, it
puts the \fIreal\fR user on the access list as well.
.PP
With the access list is initialized, only those users who appear on
an access list may place locks on files, even when running in set-uid
mode.
.SS "Directory-Level Permissions"
Before attempting to create or lock an archive file, \fBcheckin\fR
looks first for the directory-level permissions which may be set with
the \fBpermit\fR utility.
If they exist, \fBcheckin\fR limits
further access rights to those permitted.
.SH OPTIONS
\fBCheckin\fR recognizes all of the "\fBci\fR" options.
.PP
If the "\-\fBk\fR" option is used, \fBcheckin\fR supplies
a default log-message
.Es
FROM_KEYS
.Eh
.PP
Options specific to \fBcheckin\fR are:
.TP 4n
.B \-B
directs \fBcheckin\fR to ignore the \fBbaseline\fR version.
Normally, \fBcheckin\fR supplies a default version number which
augments that of \fBci\fR, by looking at the \fBbaseline\fR version.
.TP
.B \-D
causes it to display the actions it would perform,
but not to do them (e.g., invocation of \fBrcs\fR and \fBci\fR).
.TP
.B \-M\fIfilename\fP
provide the check-in message in the given file.
Normally \fBci\fP prompts you for a multiline message.
.IP
If the input is not a terminal, \fBcheckin\fP assumes that is a pipe,
and passes the text (escaped) to \fBci\fP.
That is done best in a script.
For random use, to supply the same check-in message for more
than one file, the \fB\-M\fP option lets you provide the message via a file.
.SH OPERATIONS
\fBCheckin\fR is used exactly as one would use \fBci\fR.
Place a lock on the file using the "\-\fBl\fR" option with \fBci\fR
(or with \fBco\fR) when you wish to edit a file.
Check the file
in using the "\-\fBu\fR" option to retain a working copy after
modification.
.SH ENVIRONMENT
\fBCheckin\fR is a C-language program.
It invokes \fBci\fR (with
an explicit path, to protect against mishaps in set-uid mode),
and performs pre- and
postprocessing of the archive and working file to determine
the version to which the file's modification date applies.
.PP
\fBCheckin\fR uses the following environment variables:
.TP 4n
.B RCS_BASE
is used to specify a default value for initial
revision numbers.
If the user does not specify the initial version
number of a file, \fBci\fR assigns the value "1.1".
This
is used to support the use of module-level version numbers, while
preserving the relationship between changes and revisions: a new version
is made only if the file is changed.
.IP
The directory-level revision set by the \fBpermit\fR
utility may override this environment variable.
See \fIbaseline\fR
and \fIpermit\fR for more details.
.TP
.B RCS_COMMENT
is set to a string controlling the initial setting
of the rcs "\-\fBc\fR" option.
For example, the strings
.RS
.Es
setenv RCS_COMMENT '/.c/ *> /'
.Eh
.PP
and
.Es
setenv RCS_COMMENT '/.d/# /,/.bas/REM /'
.Eh
.PP
define comment-prefixes for ".c", ".d" and ".bas"
suffixes.
(The suffix is delimited with the first "." in the
leaf-name).
.RE
.TP
.B RCS_DIR
if defined, specifies the directory in which \fIrcs\fR archive files are found.
Normally files are found in "./RCS".
.TP
.B TZ
is the POSIX time zone, which is overridden internally
so that file modification dates are independent of the local time
zone.
.SH FILES
\fBCheckin\fR uses the following files
.TP
.B ci
the RCS check-in program
.TP
.B rcs
the RCS administrative program
.SH ANTICIPATED CHANGES
None.
.SH AUTHORS
Thomas E. Dickey <dickey@invisible-island.net>
.SH SEE ALSO
baseline, rcsput, permit, ded, ci\ (1), co\ (1), rcs\ (1)
