/************************************************************************/
/* 									*/
/* 	XTarTool.cc: XawPlus interface to GNU tar			*/
/*		     This program is inspired by XTar and Winzip	*/
/*		     Roland Krause 1998, 1999				*/
/*									*/
/************************************************************************/

// --- Include ----------------------------------------------------------

// Header of Xt

#include <X11/Intrinsic.h>	// Header of Xt

// Header of this application

#include "MainWin.h"		// Class to create the main window
#include "FileSelect.h"		// Class to create the file selector
#include "ExtrDialog.h"		// Class to create the file extraction dialog


//--- Fallback resources, used if no other resources are specified ------

char *fallback[] =
{ "*font: -*-lucidatypewriter-medium-r-*-*-12-*-*-*-*-*-iso8859-1", // Default font
  "*Command*font:		7x13bold",	// Font for the buttons
  "*Toggle*font:		7x13bold",	// Font for toggles
  "*fileDialogShell*Command.width: 80",		// Width for the buttons
  "*Toggle.width:		80",		// Width for the toggles
  "*title.label:		XTarTool V 0.6",

  "*quit.bitmap:		exit.xpm",	// Close xtartool
  "*quit.clipMask:		exit.xpm",
  "*quit.helpText:		Close xtartool",

  "*open.bitmap:		open.xpm",	// Open an existing archive
  "*open.clipMask:		open.xpm",
  "*open.helpText:		Open an existing archive",

  "*view.bitmap:		view.xpm",	// View files
  "*view.clipMask:		view.xpm",
  "*view.helpText:		View the selected files",

  "*extract.bitmap:		extract.xpm",	// Extract files
  "*extract.clipMask:		extract.xpm",
  "*extract.helpText:		Extract the selected files from the archive",

  "*extrAll.bitmap:		extrAll.xpm",	// Extract all files
  "*extrAll.clipMask:		extrAll.xpm",
  "*extrAll.helpText:		Extract all files from the archive",

  "*new.bitmap:			new.xpm",	// Create new archive
  "*new.clipMask:		new.xpm",
  "*new.helpText:		Create a new archive",

  "*basePanel.height:		540",		// Width and height of the
  "*basePanel.width:		670",		// main window

  // Tar list

  "*selectList.scrollVertical:		WhenNeeded",
  "*selectList.scrollHorizontal:	WhenNeeded",

  // File selection dialog

  "*fileDialogShell.width:	420",		// Width and height of the dialog
  "*listView.preferredPaneSize:	370",
  "*fileDialogShell.title:	Open tar file",	// Title
  "*selectList.defaultColumns:	1",		// Use only one column
  "*selectLabel.label:		File :",
  "*fileButtons.ok.label:	Ok",		// Labels of the buttons
  "*fileButtons.cancel.label:	Cancel",

  // File viewer

  "*viewerPanel.viewer.width:		570",	// Width and height of the window
  "*viewerPanel.viewer.height:		530",
  "*viewerPanel.viewer.scrollVertical:	WhenNeeded",
  "*viewerPanel.viewer.scrollHorizontal:WhenNeeded",
  "*viewerPanel.done.label:		Done",	// Done button

  // File extraction dialog

  "*extrShell.title:		Extract files from tar archive",
  "*extrShell.width:		450",
  "*extrShell*pathLabel.label:	Extract files to :",
  "*extrShell*ok.label:		Ok",
  "*extrShell*abort.label:	Cancel",

  NULL };


// --- main() -----------------------------------------------------------

int main(int argc, char *argv[])
{
   XtAppContext		app;
   Widget		mainShell;

   // Initialize Xt

   mainShell = XtAppInitialize(&app, "XTarTool", NULL, 0, &argc, argv, fallback, NULL, 0);

   // Create all objects: All objects are destroyed in the
   // EndOfProg() callback of mainWin.

   FileSelect *fileSelector = new FileSelect(mainShell);  	// Create the file dialog
   ExtrDialog *extrDialog = new ExtrDialog(mainShell);		// Create the extraction dialog
   MainWin *mainWin = new MainWin(mainShell, fileSelector, extrDialog);	// Create the main window

   mainWin->RunIt(app, mainShell, argv[1]);		// Start the application
}



